VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "U3800 GPIB CH1CH2 Power Ver. 1.0"
   ClientHeight    =   8175
   ClientLeft      =   1530
   ClientTop       =   1935
   ClientWidth     =   9585
   Icon            =   "Form1.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   8175
   ScaleWidth      =   9585
   Begin VB.TextBox Text4 
      Alignment       =   1  'Right Justify
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000FF&
      Height          =   375
      Left            =   4320
      TabIndex        =   40
      Top             =   1200
      Width           =   855
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Overlay"
      Height          =   375
      Index           =   8
      Left            =   3600
      TabIndex        =   38
      Top             =   7440
      Width           =   975
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select SPA"
      Height          =   1095
      Left            =   1560
      TabIndex        =   35
      Top             =   6840
      Width           =   1455
      Begin VB.OptionButton Option2 
         Caption         =   "U3872"
         Height          =   255
         Left            =   120
         TabIndex        =   37
         Top             =   720
         Width           =   1095
      End
      Begin VB.OptionButton Option1 
         Caption         =   "U3841/51"
         Height          =   255
         Left            =   120
         TabIndex        =   36
         Top             =   360
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Spuri+Pow+AVG"
      Height          =   495
      Index           =   12
      Left            =   7800
      Style           =   1  'Graphical
      TabIndex        =   34
      Top             =   2280
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFF80&
      Caption         =   "Meas(2) ALL"
      Height          =   495
      Index           =   11
      Left            =   7800
      Style           =   1  'Graphical
      TabIndex        =   33
      Top             =   1080
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "OBW (99%)"
      Height          =   495
      Index           =   10
      Left            =   5760
      Style           =   1  'Graphical
      TabIndex        =   30
      Top             =   1200
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Freq + AVG"
      Height          =   495
      Index           =   9
      Left            =   7800
      Style           =   1  'Graphical
      TabIndex        =   29
      Top             =   1680
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "Frequency"
      Height          =   495
      Index           =   8
      Left            =   4080
      Style           =   1  'Graphical
      TabIndex        =   28
      Top             =   480
      Width           =   1575
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SCRF OFF"
      Height          =   375
      Index           =   7
      Left            =   8040
      TabIndex        =   27
      Top             =   7440
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SCRF ON"
      Height          =   375
      Index           =   6
      Left            =   8040
      TabIndex        =   26
      Top             =   6960
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Dual OFF"
      Height          =   375
      Index           =   5
      Left            =   6480
      TabIndex        =   25
      Top             =   7440
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Dual ON"
      Height          =   375
      Index           =   4
      Left            =   6480
      TabIndex        =   24
      Top             =   6960
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Full CH2"
      Height          =   375
      Index           =   3
      Left            =   4800
      TabIndex        =   23
      Top             =   7440
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Full CH1"
      Height          =   375
      Index           =   2
      Left            =   4800
      TabIndex        =   22
      Top             =   6960
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "SPLIT"
      Height          =   375
      Index           =   1
      Left            =   3600
      TabIndex        =   21
      Top             =   6960
      Width           =   975
   End
   Begin VB.CommandButton Command3 
      Caption         =   "Preset"
      Height          =   375
      Index           =   0
      Left            =   360
      TabIndex        =   20
      Top             =   7200
      Width           =   975
   End
   Begin VB.CommandButton Command1 
      Caption         =   "ACP"
      Height          =   375
      Index           =   7
      Left            =   480
      TabIndex        =   19
      Top             =   2520
      Width           =   735
   End
   Begin VB.CommandButton Command1 
      Caption         =   "CHP"
      Height          =   375
      Index           =   0
      Left            =   480
      TabIndex        =   18
      Top             =   2040
      Width           =   735
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0080FFFF&
      Caption         =   "Spurious (CH1)"
      Height          =   495
      Index           =   6
      Left            =   360
      Style           =   1  'Graphical
      TabIndex        =   17
      Top             =   1200
      Width           =   1575
   End
   Begin VB.CheckBox AvgMode 
      Caption         =   "AVG ON"
      Height          =   375
      Left            =   3720
      TabIndex        =   16
      Top             =   120
      Width           =   975
   End
   Begin VB.CommandButton Command2 
      BackColor       =   &H00C0C0FF&
      Caption         =   "EXIT"
      Height          =   495
      Left            =   6480
      Style           =   1  'Graphical
      TabIndex        =   15
      Top             =   2280
      Width           =   855
   End
   Begin VB.TextBox Text3 
      Height          =   285
      Left            =   5040
      TabIndex        =   7
      Text            =   "1000"
      Top             =   2400
      Width           =   735
   End
   Begin VB.TextBox Text2 
      Height          =   285
      Left            =   3480
      TabIndex        =   6
      Text            =   "20"
      Top             =   2400
      Width           =   735
   End
   Begin VB.TextBox Text1 
      Height          =   315
      Left            =   1560
      TabIndex        =   5
      Text            =   "2412"
      Top             =   2400
      Width           =   1095
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0000FFFF&
      Caption         =   "Meas (1) ALL"
      Height          =   495
      Index           =   5
      Left            =   7800
      Style           =   1  'Graphical
      TabIndex        =   3
      Top             =   480
      Width           =   1455
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0080FFFF&
      Caption         =   "OBW (90%)"
      Height          =   495
      Index           =   4
      Left            =   2040
      Style           =   1  'Graphical
      TabIndex        =   2
      Top             =   1200
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0080FFFF&
      Caption         =   "OBW (99%)"
      Height          =   495
      Index           =   3
      Left            =   2040
      Style           =   1  'Graphical
      TabIndex        =   1
      Top             =   480
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H00FFFFC0&
      Caption         =   "AVG Power (1M)"
      Height          =   495
      Index           =   2
      Left            =   5760
      Style           =   1  'Graphical
      TabIndex        =   4
      Top             =   480
      Width           =   1575
   End
   Begin VB.CommandButton Command1 
      BackColor       =   &H0080FFFF&
      Caption         =   "Total Power"
      Height          =   495
      Index           =   1
      Left            =   360
      Style           =   1  'Graphical
      TabIndex        =   0
      Top             =   480
      Width           =   1575
   End
   Begin VB.TextBox txtRslt 
      BeginProperty Font 
         Name            =   "lr SVbN"
         Size            =   9
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3495
      Left            =   360
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   8
      Top             =   3120
      Width           =   8835
   End
   Begin VB.Label Label10 
      Caption         =   "sec"
      Height          =   255
      Left            =   5280
      TabIndex        =   41
      Top             =   1320
      Width           =   375
   End
   Begin VB.Label Label9 
      Caption         =   "CH1 + CH2"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   8040
      TabIndex        =   39
      Top             =   120
      Width           =   975
   End
   Begin VB.Line Line11 
      BorderColor     =   &H80000011&
      X1              =   6240
      X2              =   7680
      Y1              =   6840
      Y2              =   6840
   End
   Begin VB.Line Line10 
      BorderColor     =   &H80000011&
      X1              =   6240
      X2              =   7680
      Y1              =   7920
      Y2              =   7920
   End
   Begin VB.Line Line9 
      BorderColor     =   &H80000011&
      X1              =   7680
      X2              =   7680
      Y1              =   6840
      Y2              =   7920
   End
   Begin VB.Line Line8 
      BorderColor     =   &H80000011&
      X1              =   6240
      X2              =   6240
      Y1              =   6840
      Y2              =   7920
   End
   Begin VB.Line Line7 
      BorderColor     =   &H80000011&
      X1              =   6000
      X2              =   6000
      Y1              =   6840
      Y2              =   7920
   End
   Begin VB.Line Line6 
      BorderColor     =   &H80000011&
      X1              =   6000
      X2              =   3360
      Y1              =   6840
      Y2              =   6840
   End
   Begin VB.Line Line5 
      BorderColor     =   &H80000011&
      X1              =   3360
      X2              =   3360
      Y1              =   6840
      Y2              =   7920
   End
   Begin VB.Line Line4 
      BorderColor     =   &H80000011&
      X1              =   6000
      X2              =   3360
      Y1              =   7920
      Y2              =   7920
   End
   Begin VB.Label Label8 
      Caption         =   "Measurement (2)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5040
      TabIndex        =   32
      Top             =   120
      Width           =   1575
   End
   Begin VB.Label Label7 
      Caption         =   "Measurement (1)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   1320
      TabIndex        =   31
      Top             =   120
      Width           =   1575
   End
   Begin VB.Line Line2 
      BorderColor     =   &H00C00000&
      X1              =   3840
      X2              =   3840
      Y1              =   480
      Y2              =   1680
   End
   Begin VB.Line Line1 
      BorderColor     =   &H008080FF&
      X1              =   360
      X2              =   7320
      Y1              =   1920
      Y2              =   1920
   End
   Begin VB.Line Line3 
      BorderColor     =   &H00C00000&
      X1              =   7560
      X2              =   7560
      Y1              =   480
      Y2              =   2880
   End
   Begin VB.Label Label6 
      Caption         =   "m sec"
      Height          =   255
      Left            =   5880
      TabIndex        =   14
      Top             =   2520
      Width           =   495
   End
   Begin VB.Label Label5 
      Caption         =   "Sweep Time"
      Height          =   255
      Left            =   5040
      TabIndex        =   13
      Top             =   2040
      Width           =   975
   End
   Begin VB.Label Label4 
      Caption         =   "dBm"
      Height          =   255
      Left            =   4320
      TabIndex        =   12
      Top             =   2520
      Width           =   495
   End
   Begin VB.Label Label3 
      Caption         =   "Ref.Level"
      Height          =   255
      Left            =   3480
      TabIndex        =   11
      Top             =   2040
      Width           =   855
   End
   Begin VB.Label Label2 
      Caption         =   "MHz"
      Height          =   255
      Left            =   2760
      TabIndex        =   10
      Top             =   2520
      Width           =   495
   End
   Begin VB.Label Label1 
      Caption         =   "Frequency"
      Height          =   255
      Left            =   1680
      TabIndex        =   9
      Top             =   2040
      Width           =   975
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
'*----------------------------------------------------------------------
'*.Program Name :        2ch_Parallel_Meas_Sample (Address:8)
'*
'*      Sample software for Advantest Spectrum Analyzer U37xx
'*
'*.Description :
'*
'*.Revision History :
'*      Reference Program:              SampleWLAN by Hirakoso
'*      1.00:           01-Jul-2009     Release. by Hirakoso
'*
'*      U3800 V10       07-Dec-2011     Release for U3800
'*                                          by Hirakoso
'*
'*----------------------------------------------------------------------
'*.Copyright(c) 2009,2011 ADVANTEST CORPORATION
'*.http://www.advantest.co.jp
'*----------------------------------------------------------------------

Dim MFREQ As Double                     'Center Frequency
Dim REFL As Double                      'Reference Level
Dim SWPT As Double                      'Sweep Time
Dim starttime As Double
'


Private Sub Command1_Click(Index As Integer)


MFREQ = Val(Text1) * 1000000#
REFL = Val(Text2)
SWPT = Val(Text3)

If MeasExeFlag = 0 Then                     'Measurement Reday?

    MeasExeFlag = 1                         'Yes: Start Measurement
    Text4.Text = ""                         'Clear Measurement Time
    
    Call ibdev(0, 8, 0, 13, 1, 0, ud)       'GPIB Addr=8, Time out=10sec
    
    Select Case Index
    
    Case 0
    
        MeasChPow MFREQ, REFL               'Channel Power
    
    Case 1
    
        MeasTotpw MFREQ, REFL               'Total Power
    
    Case 2
    
        MeasZeropw MFREQ, REFL              'Zero Span Mode Power (1MHz RBW)
        
    Case 3
    
        MeasOBW MFREQ, REFL, 99#            'OBW 99%
    
    Case 4
    
        MeasOBW MFREQ, REFL, 90#            'OBW 90%
    
    Case 5
        
        AvgMode.value = 0                   'Average Mesurement Off
        MeasSpuTotOBW2 MFREQ, REFL          'Spurious, TotPower, OBW99, OBW90
    
    Case 6
    
        MeasSpurious MFREQ, REFL            'Spurious Meas Mode
        
    Case 7
    
        MeasACP MFREQ, REFL                 'ACP
        
    Case 8
    
        MeasFreq MFREQ, REFL                'g
    
    Case 9
    
        AvgMode.value = 0                   'Average Mesurement Off
        MeasAVGPowerFreq MFREQ, REFL        'g{AVG Power
        
    Case 10
    
        MeasOBW MFREQ, REFL, 99#            'OBW 99%
        
    Case 11
    
        AvgMode.value = 0                   'Average Mesurement Off
        MeasAVGPwrOBW99Freq MFREQ, REFL     'g{AVG Power + OBW99
        
    Case 12
    
        AvgMode.value = 0                   'Average Mesurement Off
        MeasSpuTotAVGpwr MFREQ, REFL        'Spurious, TotPower, AVG Power
        
    Case Else
    
    End Select
    
    DoEvents
        
    Call ibonl(ud, 0)                       'GPIB device 
    Call ibonl(0, 0)                        'GPIB board 
    
    AvgMode.value = 0                       'Average Mesurement Off
    MeasExeFlag = 0                         'End of Measurement
    
Else
    Beep                                    'Error: Measurement now
End If


End Sub


'===============================================================================
'                           Channel Power Measurement
'===============================================================================

Sub MeasChPow(measF As Double, measRef As Double)
Dim Power As Double


    Call ibdev(0, 8, 0, 13, 1, 0, ud)   'GPIB Addr=8, Time out=10sec
    
    txtRslt.SelText = vbCrLf & "CH Power Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 40 MZ")                      'Span 40MHz
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
    ' Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    Call ibwrt(ud, "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, "WLX " & Format(measF) & "HZ")   'Ch Center
    Call ibwrt(ud, "WDX 22 MZ")                     'Ch Span
    
    Call ibwrt(ud, "PWCHON")                        'Ch Pow ON
    '------------------------------------------------
    
    DoEvents                                        'Execute
    
    Call GetChPower(Power)                          'Measurement
    
    'ʕ\
    txtRslt.SelText = "CH Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
'------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "CONTS")                         'Sweep continue

    Call ibonl(ud, 0)                               'GPIB device 
    Call ibonl(0, 0)                                'GPIB board 

End Sub


Sub GetChPower(Power As Double)
Dim sBuff As String * 50

    If AvgMode.value = 0 Then                       'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWCHTM 10")                     'CH Power AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait MEAS end
    End If
    
    Call ibwrt(ud, "PWCH?")                         'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

End Sub


'===============================================================================
'                           Total Power Measurement
'===============================================================================

Sub MeasTotpw(measF As Double, measRef As Double)
Dim Power As Double


    txtRslt.SelText = vbCrLf & "Total Power Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 25 MZ")                      'Span 40MHz
    Call ibwrt(ud, "RB 1MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
 '   Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    Call ibwrt(ud, "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level

    Call ibwrt(ud, "PWTOTALON")                     'Ch Pow ON
    '-----------------------------------------------
    
    DoEvents                                        'Execute
    
    Call GetTotPower(Power)                         'Measurement
    
    'ʕ\
    txtRslt.SelText = "Total Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
'------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "CONTS")                         'Sweep continue


End Sub


Sub GetTotPower(Power As Double)
Dim sBuff As String * 50
    
    If AvgMode.value = 0 Then                       'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                            'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "PWTOTALTM 10")                  'TOTAL POW/ AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait MEAS end
    End If
    
    Call ibwrt(ud, "PWTOTAL?")                      'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

End Sub


'===============================================================================
'                           OBW n% Measurement
'===============================================================================

Sub MeasOBW(measF As Double, measRef As Double, percent As Double)
Dim sBuff As String * 50
Dim dRslt() As String

    
    txtRslt.SelText = vbCrLf & "OBW " & Format(percent) & "% Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "PMEASAVG OFF")                  'AVG OFF
    Call ibwrt(ud, "SP 25 MZ")                      'Span 40MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 1 MZ; VB 1 MZ")              'RBW, VBW setting
  '  Call ibwrt(ud, "AS")                            'Sweep Time Auto
    Call ibwrt(ud, "SW" & Format(SWPT) & "MS")
    Call ibwrt(ud, "DET POS")                       'Detector mode (POSI)
                                                       'Auto --> Average DET
    Call ibwrt(ud, "OBWPER" & Format(percent))      'OBW percent setting

    Call ibwrt(ud, "OBWON")                         'Meas OBW
    '------------------------------------------------
    
    DoEvents                                        'Execute
    
    If AvgMode.value = 0 Then                   'AverageȂꍇ
        Call ibwrt(ud, "TS")                            'Sweep once
    Else                                        'Averageꍇ
        Call ibwrt(ud, "PMEASAVGONCE ONCE")             'AVG single
        Call ibwrt(ud, "OBWTM 10")                      'OBW AVG 10 times
        Call ibwrt(ud, "PMEASAVG ON")                   'AVG start
        Call ibwrt(ud, "CONTS")                         'Sweep continue
        WaitMeasEnd                                     'Wait MEAS end
'--------------------------------------------------------TRACE AVG----------
'        Call ibwrt(ud, "AGSGL")                         'AVG single
'        Call ibwrt(ud, "AG 10")                         'AVG 10 times
'        Call ibwrt(ud, "AGR")                           'AVG start
'        Call ibwrt(ud, "CONTS")                         'Sweep continue
'        WaitAvgEnd                                      'Wait AVG end
'---------------------------------------------------------------------------
    End If
    
    sBuff = ""
    Call ibwrt(ud, "OBW?")                          'GET OBW data
    Call ibrd(ud, sBuff)                            'GET OBW data
        
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW " & Format(percent) & "% = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz"
    txtRslt.SelText = " : OBW CF = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
'------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf

    Call ibwrt(ud, "OBWON OFF")
    Call ibwrt(ud, "AGS")                           'AVG off
    Call ibwrt(ud, "CONTS")                         'Sweep continue
    
    Call ibwrt(ud, "DETAA ON")                      'Detector mode (Auto)


End Sub

'===============================================================================
'                           ACP Measurement
'===============================================================================

Sub MeasACP(measF As Double, measRef As Double)

Dim rdBuf(2) As String * 100, rdRef As String * 100
Dim dRslt5() As String, dRslt10() As String
Dim Mcount, Avgcount As Integer

    
    txtRslt.SelText = vbCrLf & "ACP Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    Call ibwrt(ud, "SI")                            'Sweep STOP
        
    Call ibwrt(ud, "SP 25MZ")                       'Span 25MHz
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RB 30KZ; VB 30KZ")              'RBW 30kHz, VBW 30kHz
  '  Call ibwrt(ud, "AS")                            'Sweep Time Auto
    Call ibwrt(ud, "SW" & Format(SWPT) & "MS")
    Call ibwrt(ud, "ACPSCR CARR")                   'ACP Carrier power
    Call ibwrt(ud, "CARRBS 3.84MZ")                 'ACP Carrier bandwidth
    Call ibwrt(ud, "CSBSDEL")                       'ACP Clear table
    Call ibwrt(ud, "CSBSIN 5MZ,3.84MZ")             'ACP Channel spacing and bandwidth
    Call ibwrt(ud, "CSBSIN 10MZ,3.84MZ")            'ACP Channel spacing and bandwidth
    Call ibwrt(ud, "DETAA ON")                      'DET Auto
    ' Call ibwrt(ud, "DET SMP")                       'Detector mode (sample)
                                                      'Auto --> Average DET
    Call ibwrt(ud, "ACP")                           'Execute ACP measurement
    '------------------------------------------------
    
    DoEvents                                        'Execute
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode.value = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
        
    For Mcount = 1 To Avgcount
    
        If 1 Then                                   'AverageȂꍇ
            Call ibwrt(ud, "TS")                            'Sweep once
        Else                                        'Averageꍇ
            Call ibwrt(ud, "AGSGL")                         'AVG single
            Call ibwrt(ud, "AG 10")                         'AVG 10 times
            Call ibwrt(ud, "AGR")                           'AVG start
            Call ibwrt(ud, "CONTS")                         'Sweep continue
            WaitAvgEnd                                      'Wait AVG end
        End If
        
        Call ibwrt(ud, "ACP?")                          'Get ACP data
        Call ibrd(ud, rdBuf(0))                         'Get ACP data
        Call ibrd(ud, rdBuf(1))                         'Get ACP data
        Call ibrd(ud, rdBuf(2))                         'Get ACP data
        Call ibwrt(ud, "MO")                            'Markers OFF
        
        Call ibwrt(ud, "ACPREF?")                       'Get ACP carrier data
        Call ibrd(ud, rdRef)                            'Get ACP carrier data
        
        
        'ʕ\
        dRslt5 = Split(rdBuf(1), ",")
        dRslt10 = Split(rdBuf(2), ",")
        
        txtRslt.SelText = "ACP ( -5M, +5M) = " & _
            Format(dRslt5(0) / 1000000#, "#0.00") & "MHz " & Format(dRslt5(1), "#0.00") & "dB : " & _
            Format(dRslt5(2) / 1000000#, "#0.00") & "MHz " & Format(dRslt5(3), "#0.00") & "dB" & vbCrLf
        txtRslt.SelText = "ACP (-10M,+10M) = " & _
            Format(dRslt10(0) / 1000000#, "#0.00") & "MHz " & Format(dRslt10(1), "#0.00") & "dB : " & _
            Format(dRslt10(2) / 1000000#, "#0.00") & "MHz " & Format(dRslt10(3), "#0.00") & "dB" & vbCrLf
        txtRslt.SelText = "ACP (Carr pow.) = " & Format(rdRef, "##0.00") & "dBm" & vbCrLf
       
     Next Mcount
     
     
    '==============================================================================
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
       
    Call ibwrt(ud, "DETAA ON")                      'DetectorAUTOɖ߂
    Call ibwrt(ud, "AGS")                           'AVG off
    Call ibwrt(ud, "ACP OFF; CONTS")


End Sub

'===============================================================================
'                           Spurious Measurement
'===============================================================================

Sub MeasSpurious(measF As Double, measRef As Double)

Dim buf As String * 50
Dim Mcount, Avgcount, i, j, m, n, band As Integer
Dim SWPdata1, SWPdata2, RELdata As String


    txtRslt.SelText = vbCrLf & "Spurious Measurement..." & vbCrLf & vbCrLf
    
    Call ibwrt(ud, "SYSMODE ASYNC")                 'SYNC Mode Off
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    Call ibwrt(ud, "SI")                            ' sweep single mode
    
    SWPdata1 = Format(SWPT) & "MS, "
    SWPdata2 = Format(SWPT + 300) & "MS, "
    RELdata = Format(measRef) & "DB, "
    
    ibwrt ud, "SPRTBL 0"
    ibwrt ud, "SPRFDEL"                 'Table clear
    ibwrt ud, "SPRFIN 10MZ, 2.35GZ, 1MZ, 10KZ," + SWPdata1 + RELdata + "AUTO, OFF, -26DB"
    ibwrt ud, "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB"
    
''''ibwrt ud, "SPRFIN Start, Stop, RBW, VBW, Sweep, ATT, RelL, PreAmp, Limit"
    
    band = 2                            'Band Number *****
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    
    '-------------------- Condition Setup (One Time) -------------------

    Call ibwrt(ud, "DY 0.1")                        'Peak search sensitivity
    Call ibwrt(ud, "DET POS")
'    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, "RO ON; RO 0 DB")                'Level Offset
    
    ibwrt ud, "SPURI ON"                            'Measure Spurious
    
    DoEvents                                        'Execute
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode.value = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    
    For Mcount = 1 To Avgcount
    
        ibwrt ud, "CONTS"                   'continuous sweep
        
        For i = 1 To band
           WaitSweepEnd                     'Measurement
        Next i
        
        Call ibwrt(ud, "SI")                'sweep single mode
        
        ibwrt ud, "SPURI?"
        
        buf = ""
        ibrd ud, buf                         ' Table
        txtRslt.SelText = "Spurious Table = " & buf & vbCrLf
        m = buf
            
        
        For i = 1 To m                       ' Table number
        
           buf = ""
           ibrd ud, buf
           txtRslt.SelText = "Spurious Number = " & buf & vbCrLf    ' Spurious nember
           n = buf
        
           For j = 1 To n                    ' Spurious Data
               buf = ""
               ibrd ud, buf
               txtRslt.SelText = buf & vbCrLf
           Next j
        
        Next i
    
    Next Mcount
    
    
    '------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    ibwrt ud, "SPURI OFF"               ' End of Measure Spurious
    ibwrt ud, "RO OFF"                  ' Level Offset Off
    ibwrt ud, "DETAA ON"
    ibwrt ud, "CONTS"                   ' Continuous Sweep
        

End Sub


'================================================================================
'                   Spurious + Total Power + OBW99 + OBW90 (Index=5)
'================================================================================

Sub MeasSpuTotOBW2(measF As Double, measRef As Double)
Dim Power As Double
Dim sBuff As String * 50
Dim dRslt() As String
Dim CHmode As String

Dim buf As String * 50
Dim Mcount, Avgcount, i, j, m, n, band As Integer
Dim SWPdata1, SWPdata2, RELdata As String


    txtRslt.SelText = vbCrLf & "Spurious & TOT Power & OBW 99% & OBW 90% Measurement..." & vbCrLf & vbCrLf

    Call ibwrt(ud, "SYSMODE ASYNC")                 'SYNC Mode Off
    Call ibwrt(ud, "SIALL")                         'Sweep STOP ALL CH
    
    '-------------------- Condition Setup (One Time) ------------------------
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    'CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1 (No data)
    
    SWPdata1 = Format(SWPT) & "MS, "
    SWPdata2 = Format(SWPT + 300) & "MS, "
    RELdata = Format(measRef) & "DB, "
    
    ibwrt ud, "SPRTBL 0"
    ibwrt ud, "SPRFDEL"                 'Table clear
    ibwrt ud, "SPRFIN 10MZ, 2.35GZ, 1MZ, 10KZ," + SWPdata1 + RELdata + "AUTO, OFF, -26DB"
    ibwrt ud, "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB"
    
''''ibwrt ud, "SPRFIN Start, Stop, RBW, VBW, Sweep, ATT, RelL, PreAmp, Limit"
    
    band = 2                                        'Band Number *****
    
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    '-------------------- Condition Setup (One Time) -----------------------------

    Call ibwrt(ud, CHmode + "DY 0.1")                        'Peak search sensitivity
    Call ibwrt(ud, CHmode + "DET POS")
    'Call ibwrt(ud, CHmode + "RO ON")                        'Level Offset ON
    'Call ibwrt(ud, CHmode + "RO 30DB")                      'Level Offset Data
    
    Call ibwrt(ud, CHmode + "SPURI ON")                      'Measure Spurious
    '---------------------------------------------------------

    Call ibwrt(ud, "ACTCH CH2")                     'Channel-2
    'CHmode = "X2; "                                 'Access Channel
    CHmode = ""                                     'Now CH2 (No data)
    
    Call ibwrt(ud, CHmode + "SP 25 MZ")                      'Span 40MHz
    Call ibwrt(ud, CHmode + "RB 1MZ;" + CHmode + "VB 1MZ")            'RBW 1MHz, VBW 1MHz
    'Call ibwrt(ud, CHmode + "AS")                           'SWEEP AUTO or setup
    Call ibwrt(ud, CHmode + "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, CHmode + "RO ON")                        'Level Offset ON
    'Call ibwrt(ud, CHmode + "RO 30 DB")                     'Level Offset Data
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level

    Call ibwrt(ud, CHmode + "AW; " + CHmode + "DETAA ON")              'A Write DET Auto
    Call ibwrt(ud, CHmode + "BW; " + CHmode + "DETB POS")              'B Write DET Posi
    
    Call ibwrt(ud, CHmode + "PWTOTALON")                     'Total Power ON
    Call ibwrt(ud, CHmode + "PMEASTRACE TRA")
    '---------------------------------------------------------
    
    DoEvents                                                 'Execute
    
    '------------------------------------------------------------------------------
    
    Call ibwrt(ud, "TSM")                           'Sweep All CH & Wait All CH
    
    '============================
    Call ibwrt(ud, "*CLS")                          'End All Sweep &  Clear STB
    Call ibwrt(ud, "OPR 8")                         'Check only CH1
    Call ibwrt(ud, "SI1")                           'Next Spurous Sweep Start
    
    '-----Total Power-----@@@@@@@@@@@@@@@
    
    'CHmode = "X2; "                                 'Access Channel (Now CH2)
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "AV; " + CHmode + "BV")         'A $ B View
    
    Call ibwrt(ud, CHmode + "PWTOTAL?")             'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

    'ʕ\
    txtRslt.SelText = "Total Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    Call ibwrt(ud, CHmode + "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, CHmode + "SW 20 MS")                      'High Speed Set
    
    '-------OBW99------@@@@@@@@@@@@@@@@@@
    
    Call ibwrt(ud, CHmode + "PMEASTRACE TRB")
    Call ibwrt(ud, CHmode + "OBWPER 99 %")
    Call ibwrt(ud, CHmode + "OBWON; " + CHmode + "TS")
    Call ibwrt(ud, CHmode + "OBW?")                         'GET OBW data
    sBuff = ""
    Call ibrd(ud, sBuff)                                    'GET OBW data
    
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW 99% = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz"
    txtRslt.SelText = " : Cent.F = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
        
    '-----OBW90-----@@@@@@@@@@@@@@@@@@@@@
    
    Call ibwrt(ud, CHmode + "OBWPER 90 %")
    Call ibwrt(ud, CHmode + "TS")
    Call ibwrt(ud, CHmode + "OBW?")                         'GET SBW data
    sBuff = ""
    Call ibrd(ud, sBuff)                                    'GET SBW data
    
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW 90% = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz"
    txtRslt.SelText = " : Cent.F = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
    
    '-----------------------------------------------
    '-----Spurious-----@@@@@@@@@@@@@@@@@@@@@
    
    CHmode = "X1; "                                 'Access Channel CH1 @@@@@@@@@@@@@@@@
    CH1_SweepEnd                                    'Spurious End ?
    
    ibwrt ud, CHmode + "SPURI?"
    
    buf = ""
    ibrd ud, buf                         ' Table
    txtRslt.SelText = vbCrLf & "Spurious Table = " & buf & vbCrLf
    m = buf
        
    
    For i = 1 To m                       ' Table number
    
       buf = ""
       ibrd ud, buf
       txtRslt.SelText = "Spurious Number = " & buf & vbCrLf    ' Spurious nember
       n = buf
    
       For j = 1 To n                    ' Spurious data
           buf = ""
           ibrd ud, buf
           txtRslt.SelText = buf & vbCrLf
       Next j
    
    Next i


'-------------------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, CHmode + "SPURI OFF")                ' End of Measure Spurious
    Call ibwrt(ud, CHmode + "DETAA ON")
    Call ibwrt(ud, CHmode + "AL ON")
    'Call ibwrt(ud, CHmode + "RO OFF")                   ' Level Offset Off
    Call ibwrt(ud, CHmode + "CONTS")                    ' Continuous Sweep
'
    CHmode = "X2; "                                 'Access Channel
    Call ibwrt(ud, CHmode + "OBWON OFF")
    Call ibwrt(ud, CHmode + "PMEASTRACE TRA")

    Call ibwrt(ud, CHmode + "AW")
    Call ibwrt(ud, CHmode + "BB")
    Call ibwrt(ud, CHmode + "DETAB ON")
    Call ibwrt(ud, CHmode + "AL ON")
    Call ibwrt(ud, CHmode + "CONTS")
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    

End Sub


'================================================================================
'                   Spurious + Total Power + AVG Power (Index=12)
'================================================================================

Sub MeasSpuTotAVGpwr(measF As Double, measRef As Double)
Dim Power As Double
Dim sBuff As String * 50
Dim dRslt() As String
Dim CHmode As String

Dim buf As String * 50
Dim Mcount, Avgcount, i, j, m, n, band, TRmode As Integer
Dim SWPdata1, SWPdata2, RELdata As String

    
    txtRslt.SelText = vbCrLf & "Spurious & TOT Power & AVG Power Measurement..." & vbCrLf
    
    Call ibwrt(ud, "SYSMODE ASYNC")                 'SYNC Mode Off
    Call ibwrt(ud, "SIALL")                         'Sweep STOP ALL CH
    
    '-------------------- Condition Setup (One Time) ----------------------------
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    'CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1
    
    SWPdata1 = Format(SWPT) & "MS, "
    SWPdata2 = Format(SWPT + 300) & "MS, "
    RELdata = Format(measRef) & "DB, "
    
    ibwrt ud, "SPRTBL 0"
    ibwrt ud, "SPRFDEL"                 'Table clear
    ibwrt ud, "SPRFIN 10MZ, 2.35GZ, 1MZ, 10KZ," + SWPdata1 + RELdata + "AUTO, OFF, -26DB"
    ibwrt ud, "SPRFIN 2.5GZ, 12.5GZ, 1MZ, 10KZ," + SWPdata2 + RELdata + "AUTO, OFF, -26DB"
    
''''ibwrt ud, "SPRFIN Start, Stop, RBW, VBW, Sweep, ATT, RelL, PreAmp, Limit"
    
    band = 2                                        'Band Number *****
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------

    Call ibwrt(ud, CHmode + "DY 0.1")                        'Peak search sensitivity
    Call ibwrt(ud, CHmode + "DET POS")
    'Call ibwrt(ud, CHmode + "RO ON")                        'Level Offset ON
    'Call ibwrt(ud, CHmode + "RO 30DB")                      'Level Offset Data
    
    Call ibwrt(ud, CHmode + "SPURI ON")                      'Measure Spurious
    '---------------------------------------------------------
    
    Call ibwrt(ud, "ACTCH CH2")                     'Channel-2
    'CHmode = "X2; "                                 'Access Channel
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "SP 25 MZ")                      'Span 40MHz
    Call ibwrt(ud, CHmode + "RB 1MZ;" + CHmode + "VB 1MZ")            'RBW 1MHz, VBW 1MHz
    'Call ibwrt(ud, CHmode + "AS")                           'SWEEP AUTO or setup
    Call ibwrt(ud, CHmode + "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, CHmode + "RO ON")                        'Level Offset ON
    'Call ibwrt(ud, CHmode + "RO 30 DB")                     'Level Offset Data
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level

    Call ibwrt(ud, CHmode + "DETAA ON")                      'A Write DET Auto
    
    Call ibwrt(ud, CHmode + "PWTOTALON")                     'Total Power ON
    '--------------------------------------------------------
     
    DoEvents                                                 'Execute
      
    '--------------------------------------------------------------------------
    
    Call ibwrt(ud, "TSM")                           'Sweep All CH & Wait All CH
    
    '============================
    Call ibwrt(ud, "*CLS")                          'End All Sweep &  Clear STB
    Call ibwrt(ud, "OPR 2048")                      'Check only CH2
    Call ibwrt(ud, "SI1")                           'Next Spurous Sweep Start
    
    '-----Total Power-----@@@@@@@@@@@@@@@
    
    'CHmode = "X2; "                                 'Access Channel (Now CH2)
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "PWTOTAL?")                      'GET POW data
    sBuff = ""
    Call ibrd(ud, sBuff)                            'GET POW data
    Power = sBuff

    'ʕ\--------------
    txtRslt.SelText = "Total Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    

    '-----AVG Power-----@@@@@@@@@@@@@@@
    '-----AVG Power Meas condition-----
    Call ibwrt(ud, CHmode + "PMEASOFF")                      'Power Meas OFF
    Call ibwrt(ud, CHmode + "SP 0HZ")                        'Span Zero
    Call ibwrt(ud, CHmode + "VB 3MZ")                        'VBW 3MHz
    Call ibwrt(ud, CHmode + "SW 5MS")                        'SWEEP Time 5ms or ...
    Call ibwrt(ud, CHmode + "DET AVG")                       'DET AVG
    
    '-----Sweep Start-----
    Call ibwrt(ud, CHmode + "SI2")                           'Sweep
    CH2_SweepEnd
    Call ibwrt(ud, "*CLS")                                   'End All Sweep &  Clear STB
    Call ibwrt(ud, "OPR 8")                                  'Check only CH1
    
    Call ibwrt(ud, CHmode + "AV")                            'VIEW
    
    TRmode = 1
    Call GetDataTrace(Power, TRmode, CHmode)
    
    'ʕ\--------------
    txtRslt.SelText = "AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf


    '-------------------------------------------------------------------------
    '-----Spurious-----@@@@@@@@@@@@@@@@@@@@@
    CH1_SweepEnd                                    'Spurious End ?
    
    CHmode = "X1; "                                 'Access Channel
    
    ibwrt ud, CHmode + "SPURI?"
    
    buf = ""
    ibrd ud, buf                         ' Table
    txtRslt.SelText = vbCrLf & "Spurious Table = " & buf & vbCrLf
    m = buf
        
    
    For i = 1 To m                       ' Table number
    
       buf = ""
       ibrd ud, buf
       txtRslt.SelText = "Spurious Number = " & buf & vbCrLf    ' Spurious nember
       n = buf
    
       For j = 1 To n                    ' Spurious
           buf = ""
           ibrd ud, buf
           txtRslt.SelText = buf & vbCrLf
       Next j
    
    Next i


'-------------------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, CHmode + "SPURI OFF")                ' End of Measure Spurious
    Call ibwrt(ud, CHmode + "DETAA ON")
    'Call ibwrt(ud, CHmode + "RO OFF")                   ' Level Offset Off
    Call ibwrt(ud, CHmode + "CONTS")                    ' continuous sweep
'
    CHmode = "X2; "                                 'Access Channel

    Call ibwrt(ud, CHmode + "AW")                   'A-WRITE
    Call ibwrt(ud, CHmode + "DETAA ON")
    Call ibwrt(ud, CHmode + "CONTS")
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    

End Sub


'***************************************************************************************
'                       AVG Power (ZERO SPAN BURST Measurement)
'***************************************************************************************

Sub MeasZeropw(measF As Double, measRef As Double)
Dim Power As Double
Dim sBuff As String * 50
Dim i, Avgcount, TRmode As Integer
Dim CHmode As String

    
    txtRslt.SelText = vbCrLf & "New Zero Span Mode Power Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    Call ibwrt(ud, "SI")                            'Sweep STOP
    
    Call ibwrt(ud, "DD 10")                         'dB/DIV=10
    
    Call ibwrt(ud, "SP 0HZ")                        'Span Zero
    Call ibwrt(ud, "RB 1MZ; VB 3MZ")                'RBW 1MHz, VBW 3MHz
    Call ibwrt(ud, "SW 5MS")                        'SWEEP Time 5ms or ...
    Call ibwrt(ud, "DET AVG")                       'DET AVG
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, "TS")                            'Dummy sweep
    
    DoEvents                                        'Execute
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode.value = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    For i = 1 To Avgcount
        
        Call ibwrt(ud, "AW")                            'A Write
        Call ibwrt(ud, "TS")                            'Sweep once
        Call ibwrt(ud, "AV")                            'VIEW
        
        TRmode = 0
        CHmode = ""
        Call GetDataTrace(Power, TRmode, CHmode)
     
    '-------------------------------------------------------------------------
    'ʕ\
    txtRslt.SelText = "AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
 
    Next i
    '--------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf

    Call ibwrt(ud, "PMEASOFF")                      'POW OFF
    Call ibwrt(ud, "DETAA ON")                      'DET Auto
    Call ibwrt(ud, "AW")                            'A Write
    Call ibwrt(ud, "CONTS")                         'Sweep continue


End Sub

'===================================1000 Points Version====================================

Sub GetDataTrace(Power As Double, TRmode As Integer, CHmode As String)

Dim TraceP(1000) As Integer
Dim Rslt As Integer, tmp As Integer, i As Integer
Dim CentLv As Integer, SerLv As Integer, sp As Integer

Dim StartPt As Integer
Dim dbm(1000) As Double
Dim PowerWt As Double


    Call ibwrt(ud, "DLIM2")                     ' Set EOI @U3751
    
    If TRmode = 0 Then
        Call ibwrt(ud, "TBA?")                  ' Set BIN mode
    Else
        Call ibwrt(ud, CHmode + "TBA?")
    End If
    
    Call ibrdi(ud, TraceP(), 1001 * 2)          ' Read BIN data 501 points
   
    For i = 0 To 1000 Step 1
        tmp = TraceP(i)
        Rslt = (tmp And &HFF&) * 256
        TraceP(i) = Rslt + ((tmp And &HFF00&) / 256)
    Next i
   
    Call ibwrt(ud, "DLIM0")                     'Reset EOI @U3751
   
'---------------------------------- Max Data
    tmp = 0
    For i = 0 To 1000
        If TraceP(i) > tmp Then
            tmp = TraceP(i)
        End If
    Next i
'---------------------------------- Center Limit Level
    CentLv = tmp - 2560                         ' Max Level - 2 div
'---------------------------------- Point 0 check & Serach Low Level
    sp = 0
    If TraceP(sp) > CentLv Then
        For sp = 1 To 640 Step 20
            If TraceP(sp) < CentLv Then Exit For
        Next sp
    End If
'---------------------------------- Search High Level
    For i = sp To 640 Step 10
        If TraceP(i) > CentLv Then Exit For
    Next i
'----------------------------------- Start point = i (point) + 50 (250 usec)

    StartPt = i + 50
    
'-----------------------------------
                                                         'Ref=REFL, dB/Div=10
    For i = StartPt To StartPt + 199                     '200 points = 1ms
        dbm(i) = REFL - (14592 - TraceP(i)) * 0.0078125
    Next i
        
    PowerWt = 0
    For i = StartPt To StartPt + 199
        dbm(i) = 10 ^ (dbm(i) / 10)
        PowerWt = PowerWt + dbm(i)
    Next i
    
    Power = 10 * ((Log(PowerWt / 200) / Log(10#)))
    
    
End Sub


'================================================================================
'                   Frequency Measurement
'================================================================================

Sub MeasFreq(measF As Double, measRef As Double)

Dim MkrFreq As Double
Dim i, Avgcount As Integer
Dim sBuff As String * 50

    
    txtRslt.SelText = vbCrLf & "Frequency Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------

    Call ibwrt(ud, "SI")                            'Sweep STOP
    Call ibwrt(ud, "SP 1 MZ")                       'Span 1 MHz (Check)
    Call ibwrt(ud, "RB 1 MZ; VB 1MZ")                'RBW 1MHz, VBW 1MHz
 '   Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    Call ibwrt(ud, "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, "DET POS")                       'Detector mode (POSI)
    
    DoEvents                                        'Execute
    
    '--------------------- AVG Condition ---------------------------------
    If AvgMode.value = 0 Then                   'AverageȂꍇ
        Avgcount = 1                            'Sweep once
    Else                                        'Averageꍇ
        Avgcount = 10                           '10 Sweep
    End If
    '--------------------- Measurement ---------------------------------
    For i = 1 To Avgcount
    
        Call ibwrt(ud, "TS")
        Call ibwrt(ud, "PS")
        Call ibwrt(ud, "MF?")
        sBuff = ""
        Call ibrd(ud, sBuff)
        MkrFreq = sBuff
    'ʕ\
    txtRslt.SelText = "Frequency = " & Format(MkrFreq / 1000000, "###0.000") & "MHz" & vbCrLf
    
    Next i
    
    '------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, "MKOFF")                         'Marker OFF
    Call ibwrt(ud, "CONTS")                         'Sweep continue
    Call ibwrt(ud, "DETAA ON")                      'Detector mode (Auto)


End Sub


'================================================================================
'                  Frequency + AVG Power (1MHz RBW) Measurement  (Index=9)
'================================================================================

Sub MeasAVGPowerFreq(measF As Double, measRef As Double)

Dim MkrFreq As Double
Dim i, TRmode As Integer
Dim sBuff As String * 50
Dim CHmode As String
Dim Power As Double

    
    txtRslt.SelText = vbCrLf & "Frequency & AVG Power Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    Call ibwrt(ud, "SYSMODE ASYNC")                 'SYNC Mode Off
    Call ibwrt(ud, "SIALL")                         'Sweep STOP ALL CH
        
   '---------------------------Frequency Meas condition------------------------------
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    'CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1

    Call ibwrt(ud, CHmode + "SP 1 MZ")                       'Span 1MHz (Check)
    Call ibwrt(ud, CHmode + "RB 1 MZ;" + CHmode + "VB 1MZ")             'RBW 1MHz, VBW 1MHz
 '   Call ibwrt(ud, "AS")                            'SWEEP AUTO or setup
    Call ibwrt(ud, CHmode + "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, CHmode + "DET POS")                       'Detector mode (POSI)
    
    '---------------------------AVG Power Meas condition-----------------------------
    
    Call ibwrt(ud, "ACTCH CH2")                     'Channel-2
    'CHmode = "X2; "                                 'Access Channel
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "DD 10")                         'dB/DIV=10
    Call ibwrt(ud, CHmode + "SP 0HZ")                        'Span Zero
    Call ibwrt(ud, CHmode + "RB 1MZ;" + CHmode + "VB 3MZ")             'RBW 1MHz, VBW 3MHz
    Call ibwrt(ud, CHmode + "SW 5MS")                        'SWEEP Time 5ms or ...
    Call ibwrt(ud, CHmode + "DET AVG")                       'DET AVG
    
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")               'Level Offset
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    '--------------------------------------------------------------------------------
    
    DoEvents                                        'Execute
    
    '---------------------------------- Measurement ---------------------------------
    
    Call ibwrt(ud, "TSS")                           'Sweep All & Wait CH1 Sweep end
    
    '============================
    Call ibwrt(ud, "*CLS")                          'CH1 Sweep end & Clear STB
    Call ibwrt(ud, "OPR 8")                         'Next check only CH1
    
    '-----AVG Power-----@@@@@@@@@@@@@@@@@@@@@
    'CHmode = "X2; "                                 'Access Channel
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "AW")                            'A Write
    Call ibwrt(ud, CHmode + "TS")                            'Sweep
    Call ibwrt(ud, CHmode + "AV")                            'VIEW
    
    TRmode = 1
    Call GetDataTrace(Power, TRmode, CHmode)
    
    '-------------------------------------------------------------------------
    'ʕ\
    txtRslt.SelText = "AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf

    
    '-----Frequency-----@@@@@@@@@@@@@@@@@@@@@
    CHmode = "X1; "                                 'Access Channel
    
    CH1_SweepEnd                                    'Wait of Frequency Maes End

    Call ibwrt(ud, CHmode + "PS")
    Call ibwrt(ud, CHmode + "MF?")
    sBuff = ""
    Call ibrd(ud, sBuff)
    MkrFreq = sBuff
    'ʕ\
    txtRslt.SelText = "Frequency = " & Format(MkrFreq / 1000000, "###0.000") & "MHz" & vbCrLf
    
    
    '----------------------------------------------------------------
    '-----AVG Power-----After Freq Measurement-----If you want.
    'X1 Channel: MKR Freq to CF, TS, AVG Measurement
    '----------------------------------------------------------------
    

    '---------------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
    
    Call ibwrt(ud, CHmode + "MKOFF")                         'Marker OFF
    Call ibwrt(ud, CHmode + "DETAA ON")                      'Detector mode (Auto)
    Call ibwrt(ud, CHmode + "CONTS")                         'Sweep continue
    
    CHmode = "X2; "                                 'Access Channel
    
    Call ibwrt(ud, CHmode + "DETAA ON")                      'DET Auto
    Call ibwrt(ud, CHmode + "AW")                            'A Write
    Call ibwrt(ud, CHmode + "CONTS")                         'Sweep continue
            
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1


End Sub


'================================================================================
'         Frequency + AVG Power (1MHz RBW) + OBW99 Measurement  (Index=11)
'================================================================================

Sub MeasAVGPwrOBW99Freq(measF As Double, measRef As Double)

Dim MkrFreq As Double
Dim i, TRmode As Integer
Dim sBuff As String * 50
Dim dRslt() As String
Dim CHmode As String
Dim Power As Double

    
    txtRslt.SelText = vbCrLf & "Frequency & AVG Power & OBW Measurement..." & vbCrLf
    
    starttime = Timer                               '=============================
    '-----------------------------------------------------------------------------
    
    Call ibwrt(ud, "SYSMODE ASYNC")                 'SYNC Mode Off
    Call ibwrt(ud, "ACTCH CH1")                     'Channel One
    Call ibwrt(ud, "SIALL")                         'Sweep STOP ALL CH
    
   '---------------------------OBW Meas Condition---------------------------------
    
    Call ibwrt(ud, "ACTCH CH2")                     'Channel-2
    'CHmode = "X2; "                                 'Access Channel
    CHmode = ""                                     'Now CH2
    
    Call ibwrt(ud, CHmode + "SP 25 MZ")                     'Span 40MHz
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    Call ibwrt(ud, CHmode + "RB 1MZ;" + CHmode + "VB 1MZ")   'RBW, VBW setting
  '  Call ibwrt(ud, CHmode + "AS")                           'Sweep Time Auto
    Call ibwrt(ud, CHmode + "SW" & Format(SWPT) & "MS")
    Call ibwrt(ud, CHmode + "DET POS")                       'Detector mode (POSI)
                                                             'Auto --> Average DET
    Call ibwrt(ud, CHmode + "OBWPER 99")                     'OBW percent setting
    Call ibwrt(ud, CHmode + "OBWON")                         'Meas OBW
    
    '---------------------------Frequency Meas condition----------------------------
    
    Call ibwrt(ud, "ACTCH CH1")                     'Channel-1
    'CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1

    Call ibwrt(ud, CHmode + "SP 1 MZ")                       'Span 1MHz (Check)
    Call ibwrt(ud, CHmode + "RB 1 MZ;" + CHmode + "VB 1MZ")  'RBW 1MHz, VBW 1MHz
    Call ibwrt(ud, CHmode + "SW" & Format(SWPT) & "MS")
    
    Call ibwrt(ud, CHmode + "CF " & Format(measF) & "HZ")    'Center frequency
    'Call ibwrt(ud, "RO ON; RO 30 DB")                       'Level Offset
    Call ibwrt(ud, CHmode + "RL " & Format(measRef) & "DB")  'Reference level
    
    Call ibwrt(ud, CHmode + "DET POS")                       'Detector mode (POSI)
    
    '-------------------------------------------------------------------------------
    
    DoEvents                                        'Execute
    
    '--------------------------------- Measurement ---------------------------------
    
    Call ibwrt(ud, "TSM")                           'Sweep All & Wait
    

    '-----Frequency-----@@@@@@@@@@@@@@@@@@
    'CHmode = "X1; "                                 'Access Channel
    CHmode = ""                                     'Now CH1
        
    Call ibwrt(ud, CHmode + "PS")
    Call ibwrt(ud, CHmode + "MF?")
    sBuff = ""
    Call ibrd(ud, sBuff)
    MkrFreq = sBuff
    'ʕ\
    txtRslt.SelText = "Frequency = " & Format(MkrFreq / 1000000, "###0.000") & "MHz" & vbCrLf
     
     
    '-----AVG Power-----@@@@@@@@@@@@@@@@@
    'If you want to setup center frequency: MKR Freq to CF set
    '-------------------------------------------------------------
    
    Call ibwrt(ud, CHmode + "MKOFF")                         'Marker OFF
    Call ibwrt(ud, CHmode + "DETAA ON")                      'Detector mode (Auto)
    Call ibwrt(ud, CHmode + "SP 0HZ")                        'Span Zero
    Call ibwrt(ud, CHmode + "RB 1MZ;" + CHmode + "VB 3MZ")             'RBW 1MHz, VBW 3MHz
    Call ibwrt(ud, CHmode + "SW 5MS")                        'SWEEP Time 5ms or ...
    Call ibwrt(ud, CHmode + "DET AVG")                       'DET AVG

    Call ibwrt(ud, CHmode + "TS")                            'Sweep
    Call ibwrt(ud, CHmode + "AV")                            'VIEW
    
    TRmode = 1
    Call GetDataTrace(Power, TRmode, CHmode)
    
    '-------------------------------------------------------------------------
    'ʕ\
    txtRslt.SelText = "AVG Power = " & Format(Power, "###0.00") & "dBm" & vbCrLf
    
    
    '-----OBW99-----@@@@@@@@@@@@@@@@@@@@@@@
    CHmode = "X2; "                                 'Access Channel

    sBuff = ""
    Call ibwrt(ud, CHmode + "OBW?")                 'GET OBW data
    Call ibrd(ud, sBuff)                            'GET OBW data
        
    'ʕ\
    dRslt = Split(sBuff, ",")
    txtRslt.SelText = "OBW = " & Format(dRslt(1) / 1000000#, "###0.000") & "MHz"
    txtRslt.SelText = " : OBW CF = " & Format(dRslt(0) / 1000000#, "###0.000") & "MHz" & vbCrLf
    '-------------------------------------------------------------------------------------------

 '----------------------------------------------------------------------------------------------
    MeasTimeData = Timer - starttime
    Text4.Text = Format((MeasTimeData), "###0.00")
    txtRslt.SelText = Format((MeasTimeData), "###0.000") & " sec" & vbCrLf
        
    Call ibwrt(ud, CHmode + "OBWON OFF")                     'POW OFF
    Call ibwrt(ud, CHmode + "DETAA ON")                      'DET Auto
    Call ibwrt(ud, CHmode + "CONTS")                         'Sweep continue
    
    CHmode = "X1; "                                 'Access Channel
        
    Call ibwrt(ud, CHmode + "SP 1MZ")                        'Span 1MHz
    Call ibwrt(ud, CHmode + "DETAA ON")                      'DET Auto
    Call ibwrt(ud, CHmode + "AW")                            'A Write
    Call ibwrt(ud, CHmode + "CONTS")                         'Sweep continue
        

End Sub


Private Sub Command2_Click()

    End

End Sub


Private Sub Form_Load()

    txtRslt.Text = ""

End Sub


Private Sub Command3_Click(Index As Integer)

If MeasExeFlag = 0 Then                         'Ready?

    Text4.Text = ""                             'Clear Measurement Time

    Call ibdev(0, 8, 0, 13, 1, 0, ud)           'GPIB Addr=8, Time out=10sec
    
    Select Case Index
    
    Case 0
        
        txtRslt.SelText = "Instrument Preset"
        
        Call ibwrt(ud, "IP")                    'Instrument Preset
        DoEvents                                'Execute
        Sleep 3500                              'Wait 3.5 sec
        
        If Option2.value = True Then            'U3872
            Call ibwrt(ud, "RFC RFC1")          'Set Input-Low
        End If
        
        Call ibwrt(ud, "SYSMODE ASYNC")         'SYNC Mode Off
        Call ibwrt(ud, "ACTCH CH1")             'Set Channel-1
        
        If Option1.value = True Then            'U3841/51
            txtRslt.SelText = "  ------------->>> U3841/51 Preset Done & Set ASYNC Mode" & vbCrLf & vbCrLf
        Else
            txtRslt.SelText = "  ------------->>> U3872 Preset Done & Set Input-Low, ASYNC Mode" & vbCrLf & vbCrLf
        End If
        
        Command3(1).Enabled = True
        Command3(2).Enabled = True
        Command3(3).Enabled = True
        Command3(8).Enabled = True
        
    Case 1
    
        txtRslt.SelText = "2 Screen Display Mode"
        Call ibwrt(ud, "DISP SPLIT")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
    
    Case 2
    
        txtRslt.SelText = "CH1 Display Mode"
        Call ibwrt(ud, "DISP FULL1")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
    
    Case 3
    
        txtRslt.SelText = "CH2 Display Mode"
        Call ibwrt(ud, "DISP FULL2")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
    
    Case 4
    
        txtRslt.SelText = "Dual Mode ON"
        Call ibwrt(ud, "DUAL ON")
        Command3(1).Enabled = True
        Command3(2).Enabled = True
        Command3(3).Enabled = True
        Command3(8).Enabled = True
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
    
    Case 5
    
        txtRslt.SelText = "Dual Mode OFF"
        Call ibwrt(ud, "DUAL OFF")
        Command3(1).Enabled = False
        Command3(2).Enabled = False
        Command3(3).Enabled = False
        Command3(8).Enabled = False
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
        
    Case 6
    
        txtRslt.SelText = "SCRF ON"
        Call ibwrt(ud, "SCRF ON")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
        
    Case 7
    
        txtRslt.SelText = "SCRF OFF"
        Call ibwrt(ud, "SCRF OFF")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
        
    Case 8
    
        txtRslt.SelText = "Overlay CH1 and CH2"
        Call ibwrt(ud, "DISP OLAY")
        Sleep 200
        txtRslt.SelText = "  ------------->>> Done" & vbCrLf & vbCrLf
        
    Case Else
    
    End Select

    DoEvents                                    'Execute
    
    Call ibonl(ud, 0)                           'GPIB device 
    Call ibonl(ud, 0)                           'GPIB board 

Else
    Beep                                        'Error: Measurement now
End If


End Sub

'-----------------------------------------------------------------------------------

